<?php

namespace Modules\Chat\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ConversationStatusUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $conversation;
    public $oldStatus;
    public $newStatus;
    public $user;

    public function __construct($conversation, $oldStatus, $newStatus, $user)
    {
        $this->conversation = $conversation;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
        $this->user = $user;
    }

    public function broadcastOn()
    {
        return [
            new Channel("chat.conversation.{$this->conversation->id}"),
            new Channel('chat')
        ];
    }

    public function broadcastAs()
    {
        return 'ConversationStatusUpdated';
    }

    public function broadcastWith()
    {
        return [
            'conversation_id' => $this->conversation->id,
            'old_status' => $this->oldStatus,
            'new_status' => $this->newStatus,
            'updated_by' => [
                'id' => $this->user->id,
                'name' => $this->user->name
            ],
            'conversation' => [
                'id' => $this->conversation->id,
                'status' => $this->conversation->status,
                'closed_at' => $this->conversation->closed_at,
                'closed_by' => $this->conversation->closed_by,
                'close_reason' => $this->conversation->close_reason
            ],
            'timestamp' => now()->toISOString()
        ];
    }
}
