<?php

namespace Modules\Chat\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class MessageStatusUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $messageId;
    public $status;
    public $conversationId;

    public function __construct($messageId, $status, $conversationId)
    {
        $this->messageId = $messageId;
        $this->status = $status;
        $this->conversationId = $conversationId;
        
        \Log::info('📊 MessageStatusUpdated event criado', [
            'message_id' => $messageId,
            'status' => $status,
            'conversation_id' => $conversationId
        ]);
    }

    public function broadcastOn()
    {
        return new Channel('chat.conversation.' . $this->conversationId);
    }

    public function broadcastWith()
    {
        return [
            'message_id' => $this->messageId,
            'status' => $this->status,
            'conversation_id' => $this->conversationId,
            'timestamp' => now()->toISOString()
        ];
    }

    public function broadcastAs()
    {
        return 'MessageStatusUpdated';
    }
}
