<?php

namespace Modules\Chat\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class UnreadCountUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $conversationId;
    public $unreadCount;
    public $totalUnread;

    public function __construct($conversationId, $unreadCount, $totalUnread = null)
    {
        $this->conversationId = $conversationId;
        $this->unreadCount = $unreadCount;
        $this->totalUnread = $totalUnread;
        
        \Log::info('🔢 UnreadCountUpdated event criado', [
            'conversation_id' => $conversationId,
            'unread_count' => $unreadCount,
            'total_unread' => $totalUnread
        ]);
    }

    public function broadcastOn()
    {
        return [
            new Channel('chat'), // Canal global para contador total
            new Channel('chat.conversation.' . $this->conversationId) // Canal específico
        ];
    }

    public function broadcastWith()
    {
        return [
            'conversation_id' => $this->conversationId,
            'unread_count' => $this->unreadCount,
            'total_unread' => $this->totalUnread,
            'timestamp' => now()->toISOString()
        ];
    }

    public function broadcastAs()
    {
        return 'UnreadCountUpdated';
    }
}
