<?php
// modules/Chat/Http/Controllers/Api/SettingsController.php

namespace Modules\Chat\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Modules\Core\Http\Controllers\ApiController;
use Modules\Chat\Services\EvolutionApiService;
use Illuminate\Support\Facades\Log;

class SettingsController extends ApiController
{
    /**
     * Test Evolution API connection
     */
    public function testEvolutionConnection(Request $request): JsonResponse
    {
        try {
            $config = $request->only(['api_url', 'api_key', 'instance_name']);
            
            $evolutionService = new EvolutionApiService($config);
            $result = $evolutionService->testConnection();
            
            return $this->response($result);
            
        } catch (\Exception $e) {
            Log::error('❌ Erro no teste de conexão Evolution API', [
                'error' => $e->getMessage(),
                'config' => $request->only(['api_url', 'instance_name'])
            ]);
            
            return $this->response([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    
    /**
     * Reset settings to defaults
     */
    public function resetSettings(): JsonResponse
    {
        try {
            // Implementar reset das configurações
            // Este método seria chamado pelo provider para definir defaults
            
            return $this->response([
                'success' => true,
                'message' => 'Configurações restauradas com sucesso'
            ]);
            
        } catch (\Exception $e) {
            return $this->response([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }
}