<?php
// modules/Chat/app/Resources/Chat.php

namespace Modules\Chat\Resources;

use Modules\Core\Menu\MenuItem;
use Modules\Core\Resource\Resource;
use Modules\Core\Http\Requests\ResourceRequest;
use Modules\Chat\Models\Conversation;

class Chat extends Resource
{
    /**
     * The resource displayable icon.
     */
    public static ?string $icon = 'ChatBubbleLeftRight';

    /**
     * Indicates whether the resource has detail view.
     */
    public static bool $hasDetailView = false;

    /**
     * The model the resource is related to
     */
    public static string $model = Conversation::class;

    /**
     * Get the menu items for the resource
     */
    public function menu(): array
    {
        return [
            MenuItem::make(static::label(), '/chat')
                ->icon(static::$icon)
                ->position(30),
        ];
    }

    /**
     * Provides the resource available CRUD fields
     */
    public function fields(ResourceRequest $request): array
    {
        return [];
    }

    /**
     * Get the displayable label of the resource.
     */
    public static function label(): string
    {
        return 'Chat';
    }

    /**
     * Get the displayable singular label of the resource.
     */
    public static function singularLabel(): string
    {
        return 'Chat';
    }
}