<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('chat_channels', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // "WhatsApp Principal", "Chat Interno", etc.
            $table->enum('type', [
                'evolution_api',     // WhatsApp via Evolution
                'whatsapp_business', // WhatsApp Business API
                'internal_chat',     // Chat interno entre usuários
                'telegram',          // Telegram
                'instagram',         // Instagram
                'facebook'           // Facebook Messenger
            ]);
            $table->json('config')->nullable(); // Configurações específicas do canal
            $table->boolean('is_active')->default(true);
            $table->integer('priority')->default(1); // Prioridade do canal
            $table->string('webhook_url')->nullable(); // URL do webhook
            $table->string('webhook_token')->nullable(); // Token de segurança
            $table->string('description')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['type', 'is_active']);
            $table->index('name');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('chat_channels');
    }
};