<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conversation_id')->constrained('conversations')->onDelete('cascade');
            $table->string('external_id')->nullable(); // ID no sistema externo
            $table->text('content');
            $table->enum('message_type', ['text', 'image', 'audio', 'video', 'document', 'location', 'contact', 'system'])->default('text');
            $table->boolean('is_from_contact')->default(true); // false = enviado por usuário interno, true = do contato/externo
            $table->string('sender_type')->nullable(); // 'user', 'contact', 'system' (ou FQN dos models)
            $table->unsignedBigInteger('sender_id')->nullable(); // ID do remetente
            $table->timestamp('sent_at')->useCurrent();
            $table->timestamp('delivered_at')->nullable();
            $table->timestamp('read_at')->nullable();
            $table->enum('status', ['sending', 'sent', 'delivered', 'read', 'failed', 'received'])->default('sent');
            $table->json('metadata')->nullable(); // Dados específicos (anexos, localização, etc.)
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['conversation_id', 'sent_at']);
            $table->index(['sender_type', 'sender_id']);
            $table->index(['status', 'sent_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('messages');
    }
};