<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // ✅ CAMPOS PARA FOTO DE PERFIL DO WHATSAPP (AUTOMÁTICA)
            $table->string('whatsapp_profile_photo_url', 500)->nullable()->after('avatar')
                ->comment('URL original da foto do WhatsApp');
            
            $table->string('whatsapp_profile_photo_path')->nullable()->after('whatsapp_profile_photo_url')
                ->comment('Caminho local da foto baixada do WhatsApp');
            
            $table->timestamp('whatsapp_profile_photo_updated_at')->nullable()->after('whatsapp_profile_photo_path')
                ->comment('Última atualização da foto do WhatsApp');
            
            $table->json('whatsapp_profile_metadata')->nullable()->after('whatsapp_profile_photo_updated_at')
                ->comment('Metadados da foto do WhatsApp');
            
            // ✅ CONTROLE DE PRIORIDADE DE FOTO
            $table->enum('profile_photo_preference', ['auto', 'manual', 'whatsapp'])->default('auto')->after('whatsapp_profile_metadata')
                ->comment('Preferência de foto: auto (prioriza manual), manual (só manual), whatsapp (só WhatsApp)');
            
            // ✅ ÍNDICES
            $table->index(['whatsapp_profile_photo_updated_at'], 'idx_whatsapp_photo_updated');
            $table->index(['profile_photo_preference'], 'idx_profile_photo_preference');
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropIndex('idx_whatsapp_photo_updated');
            $table->dropIndex('idx_profile_photo_preference');
            $table->dropColumn([
                'whatsapp_profile_photo_url',
                'whatsapp_profile_photo_path',
                'whatsapp_profile_photo_updated_at',
                'whatsapp_profile_metadata',
                'profile_photo_preference'
            ]);
        });
    }
};