// modules/Chat/resources/js/app.js - VERSÃO CORRIGIDA
import "../css/app.css"

// ✅ IMPORTS USANDO ALIAS CORRETOS
import PaginaChat from "@Chat/views/PaginaChat.vue"

console.log('✅ Chat Module: Carregado')

// ✅ SEGUIR PADRÃO DO CONCORDCRM
if (window.Innoclapps) {
  Innoclapps.booting(function (app, router) {
    console.log('🚀 Chat Module: Registrando rotas...')
    
    // ✅ ROTA PRINCIPAL DO CHAT
    router.addRoute({
      path: "/chat",
      component: PaginaChat,
      meta: {
        title: "Chat",
      },
    })

    // ✅ ROTA DE CANAIS
    router.addRoute({
      path: "/chat/channels", 
      component: PaginaChat,
      meta: {
        title: "Canais",
      },
    })

    // ✅ ROTA DE CONFIGURAÇÕES (LAZY LOADING)
    router.addRoute("settings", {
      path: "chat",
      component: () => import("@Chat/views/SettingsChat.vue"),
      meta: {
        title: "Configurações do Chat",
      },
    })
    
    console.log('✅ Chat Module: Rotas registradas com sucesso')
  })
} else {
  console.error('❌ Innoclapps não encontrado!')
}

// ✅ DEBUG FUNCTION
window.debugChatLocal = function() {
  console.log('=== DEBUG CHAT LOCAL ===')
  console.log('Chat Global Ativo:', window.chatGlobalInitialized)
  console.log('ChatStore:', window.chatStore?.getStats())
  console.log('WebSocket:', window.websocketService?.getStatus())
  console.log('Innoclapps:', window.Innoclapps)
}