// modules/Chat/resources/js/composables/useChatChannels.js
import { ref } from 'vue'

export function useChatChannels(currentView) {
  const showCreateChannelModal = ref(false)
  const showEditChannelModal = ref(false)
  const selectedChannel = ref(null)
  const mostrarModalNovoChat = ref(false)

  const editChannel = (channel) => {
    selectedChannel.value = channel
    showEditChannelModal.value = true
  }

  const closeChannelModals = () => {
    showCreateChannelModal.value = false
    showEditChannelModal.value = false
    selectedChannel.value = null
  }

  const handleChannelSaved = (channelData) => {
    closeChannelModals()
    if (currentView.value === 'channels') {
      window.dispatchEvent(new CustomEvent('channels-updated'))
    }
    
    if (window.Innoclapps) {
      window.Innoclapps.success('Canal salvo com sucesso!')
    }
  }

  return {
    showCreateChannelModal,
    showEditChannelModal,
    selectedChannel,
    mostrarModalNovoChat,
    editChannel,
    closeChannelModals,
    handleChannelSaved
  }
}