// modules/Chat/resources/js/composables/useChatNavigation.js
import { ref, watch } from 'vue'

export function useChatNavigation(router, route) {
  const currentView = ref('chat')

  const detectViewFromRoute = () => {
    currentView.value = route.path.includes('/channels') ? 'channels' : 'chat'
  }

  const setView = (view) => {
    currentView.value = view
    const path = view === 'channels' ? '/chat/channels' : '/chat'
    router.push({ path, query: route.query })
  }

  // Watch route changes
  watch(() => route.path, () => {
    detectViewFromRoute()
  }, { immediate: true })

  return {
    currentView,
    setView,
    detectViewFromRoute
  }
}