<?php
// modules/Chat/routes/api.php - VERSÃO FINAL CORRIGIDA

use Illuminate\Support\Facades\Route;
use Modules\Chat\Http\Controllers\Api\ConversationController;
use Modules\Chat\Http\Controllers\Api\MessageController;
use Modules\Chat\Http\Controllers\Api\ChatChannelController;
use Modules\Chat\Http\Controllers\Api\EvolutionController;
use Modules\Chat\Http\Controllers\Api\EvolutionWebhookController;
use Modules\Chat\Http\Controllers\Api\ConversationAssignmentController;
use Modules\Chat\Http\Controllers\Api\MediaProxyController;

// ===== ROTAS DE MÍDIA (SEM AUTENTICAÇÃO) =====
Route::prefix('chat/media')->name('chat.media.')->group(function () {
    Route::get('/{attachment}/serve', [MediaProxyController::class, 'serve'])->name('serve');
    Route::get('/{attachment}/thumbnail', [MediaProxyController::class, 'thumbnail'])->name('thumbnail');
});

// ===== WEBHOOKS (SEM AUTENTICAÇÃO) =====
Route::prefix('evolution/webhook')->name('evolution.webhook.')->group(function () {
    Route::post('/{instanceName}', [EvolutionWebhookController::class, 'handle'])->name('receive');
    Route::get('/{instanceName}', [EvolutionWebhookController::class, 'verify'])->name('verify');
    Route::post('/{instanceName}/{eventName}', [EvolutionWebhookController::class, 'handleByEvent'])->name('catch-all');
});

// ===== ROTAS AUTENTICADAS =====
Route::middleware(['auth:sanctum'])->group(function () {
    
    // ✅ CANAIS DE CHAT
    Route::prefix('chat')->group(function () {
        // Canais - CRUD completo
        Route::apiResource('channels', ChatChannelController::class);
        
        // Ações específicas dos canais
        Route::patch('channels/{channel}/toggle-status', [ChatChannelController::class, 'toggleStatus']);
        Route::post('channels/{channel}/test-connection', [ChatChannelController::class, 'testConnection']);
        Route::post('channels/{channel}/test-evolution', [ChatChannelController::class, 'testEvolutionChannel']);
        Route::post('channels/{channel}/sync-evolution', [ChatChannelController::class, 'syncEvolutionChannel']);
        Route::get('channels/{channel}/stats', [ChatChannelController::class, 'stats']);
        Route::delete('channels/{channel}/force-delete', [ChatChannelController::class, 'forceDestroy']);
        
        // ✅ INSTÂNCIAS EVOLUTION - ROTAS CORRIGIDAS
        Route::get('evolution-instances', [ChatChannelController::class, 'getEvolutionInstances']);
        Route::post('evolution-instances/create-from-api', [ChatChannelController::class, 'createInstanceFromEvolution']);
        
        // Tipos de canal disponíveis
        Route::get('channels/types/available', function () {
            return response()->json([
                'types' => [
                    'evolution_api' => 'Evolution API',
                    'whatsapp_business' => 'WhatsApp Business',
                    'internal_chat' => 'Chat Interno',
                    'telegram' => 'Telegram',
                    'instagram' => 'Instagram',
                    'facebook' => 'Facebook'
                ]
            ]);
        });
    });
    
    // ✅ EVOLUTION API MANAGEMENT - ROTAS CORRIGIDAS
    Route::prefix('evolution')->name('evolution.')->group(function () {
        Route::get('instances', [EvolutionController::class, 'index'])->name('instances');
        Route::post('instances', [EvolutionController::class, 'store'])->name('store');
        Route::get('instances/{instanceName}', [EvolutionController::class, 'show'])->name('instance.details');
        Route::put('instances/{instanceName}', [EvolutionController::class, 'update'])->name('update');
        Route::delete('instances/{instanceName}', [EvolutionController::class, 'destroy'])->name('destroy');
        
        // ✅ ROTAS ESPECÍFICAS DE CONEXÃO E STATUS
        Route::get('instances/{instanceName}/status', [EvolutionController::class, 'connectionStatus'])->name('instance.status');
        Route::get('instances/{instanceName}/qrcode', [EvolutionController::class, 'getQrCode'])->name('instance.qrcode');
        Route::post('instances/{instanceName}/connect', [EvolutionController::class, 'connect'])->name('instance.connect');
        Route::delete('instances/{instanceName}/disconnect', [EvolutionController::class, 'disconnect'])->name('instance.disconnect');
        Route::post('instances/{instanceName}/test', [EvolutionController::class, 'testConnection'])->name('instance.test');
        Route::get('instances/{instanceName}/stats', [EvolutionController::class, 'stats'])->name('instance.stats');
        Route::post('instances/{instanceName}/sync', [EvolutionController::class, 'sync'])->name('instance.sync');
        Route::post('instances/{instanceName}/webhook/setup', [EvolutionController::class, 'setupWebhook'])->name('instance.webhook.setup');
        
        Route::prefix('webhooks')->name('webhooks.')->group(function () {
            Route::get('/', [EvolutionWebhookController::class, 'index'])->name('index');
            Route::get('/{webhookId}', [EvolutionWebhookController::class, 'show'])->name('show');
            Route::post('/{webhookId}/retry', [EvolutionWebhookController::class, 'retry'])->name('retry');
            Route::get('/stats/summary', [EvolutionWebhookController::class, 'stats'])->name('stats');
        });
    });
    
    // ✅ CONVERSAS
    Route::prefix('chat/conversations')->group(function () {
        Route::get('summary', [ConversationController::class, 'summary']);
        Route::get('archived', [ConversationController::class, 'archived']);
        Route::get('/', [ConversationController::class, 'index']);
        Route::post('/', [ConversationController::class, 'store']);
        Route::post('internal', [ConversationController::class, 'createInternalChat']);
        Route::put('{id}/finalize', [ConversationController::class, 'finalize']);
        Route::put('{id}/reopen', [ConversationController::class, 'reopen']);
        
        Route::prefix('{conversation}')->group(function () {
            Route::get('/', [ConversationController::class, 'show']);
            Route::patch('/', [ConversationController::class, 'update']); 
            Route::delete('/', [ConversationController::class, 'destroy']);
            Route::post('read', [ConversationController::class, 'markAsRead']);
            Route::put('status-toggle', [ConversationController::class, 'toggleConversationStatus']);
            Route::get('export', [ConversationController::class, 'export']);
            
            Route::get('messages', [MessageController::class, 'index']);
            Route::post('messages', [MessageController::class, 'store']);
            Route::post('typing', [MessageController::class, 'typing']); 

            // ATRIBUIÇÕES
            Route::patch('assign', [ConversationAssignmentController::class, 'assignConversation']);
            Route::post('assignments', [ConversationAssignmentController::class, 'assignMultipleUsers']);
            Route::get('assignments', [ConversationAssignmentController::class, 'getAssignments']);
            Route::delete('assignments/{user}', [ConversationAssignmentController::class, 'removeUserAssignment']);

        });
    });

    // ✅ USUÁRIOS E ESTATÍSTICAS
    Route::get('chat/users', [ConversationController::class, 'getUsers']);
    Route::get('chat/stats', [ConversationController::class, 'getStats']);
    Route::get('chat/media/proxy/{attachment}', [MediaProxyController::class, 'proxy'])->name('chat.media.proxy');
});