<?php
// modules/Chat/config/chat.php

return [
    'evolution_api' => [
        'base_url' => env('EVOLUTION_API_BASE_URL', 'http://localhost:8080'),
        'api_key' => env('EVOLUTION_API_KEY'),
        'instance' => env('EVOLUTION_API_INSTANCE', 'default'),
    ],
    
    'webhook' => [
        'verify_ssl' => env('CHAT_WEBHOOK_VERIFY_SSL', true),
        'timeout' => env('CHAT_WEBHOOK_TIMEOUT', 30),
    ],
    
    'attachments' => [
        'max_size' => env('CHAT_MAX_ATTACHMENT_SIZE', 10240), // KB
        'allowed_types' => [
            'image/jpeg',
            'image/png',
            'image/gif',
            'audio/mpeg',
            'audio/wav',
            'video/mp4',
            'application/pdf',
            'application/msword',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
        ]
    ]
];