<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('conversations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('contact_id')->nullable()->constrained('contacts')->onDelete('cascade');
            $table->foreignId('chat_channel_id')->constrained('chat_channels');
            $table->string('external_id')->nullable(); // ID no sistema externo (WhatsApp, etc.)
            $table->string('contact_phone')->nullable(); // Para canais externos
            $table->string('contact_identifier')->nullable(); // Email, username, etc.
            $table->enum('status', ['active', 'closed', 'waiting', 'archived'])->default('active');
            $table->enum('type', ['external', 'internal'])->default('external'); // Externo ou interno
            $table->foreignId('assigned_user_id')->nullable()->constrained('users');
            $table->timestamp('last_message_at')->nullable();
            $table->json('metadata')->nullable(); // Dados específicos do canal
            $table->integer('unread_count')->default(0);
            
            // ✅ NOVOS CAMPOS PARA FINALIZAR ATENDIMENTO
            $table->foreignId('closed_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('closed_at')->nullable();
            $table->text('close_reason')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['status', 'last_message_at']);
            $table->index(['contact_id', 'chat_channel_id']);
            $table->index(['type', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('conversations');
    }
};