<?php
// modules/Chat/Database/Migrations/xxxx_create_message_attachments_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('message_attachments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('message_id')->constrained('messages')->onDelete('cascade');
            $table->string('file_name');
            $table->string('file_path');
            $table->string('file_type');
            $table->unsignedBigInteger('file_size');
            $table->string('mime_type');
            $table->string('external_url')->nullable(); // URL da mídia na API externa
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void // Adicionado 'void' aqui
    {
        Schema::dropIfExists('message_attachments');
    }
};