<?php
// modules/Chat/Database/Migrations/xxxx_add_whatsapp_fields_to_contacts_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->string('whatsapp_number')->nullable()->after('cf_chatwootid_contato');
            $table->timestamp('last_whatsapp_interaction')->nullable()->after('whatsapp_number');
            $table->boolean('whatsapp_opt_in')->default(false)->after('last_whatsapp_interaction');
        });
    }

    public function down()
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn(['whatsapp_number', 'last_whatsapp_interaction', 'whatsapp_opt_in']);
        });
    }
};