<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('conversations', function (Blueprint $table) {
            $table->boolean('is_pinned')->default(false)->after('metadata'); // Adiciona depois da coluna metadata
            $table->boolean('is_muted')->default(false)->after('is_pinned'); // Adiciona depois da is_pinned
        });
    }

    public function down(): void
    {
        Schema::table('conversations', function (Blueprint $table) {
            $table->dropColumn(['is_pinned', 'is_muted']);
        });
    }
};