<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('conversations', function (Blueprint $table) {
            // ✅ CAMPOS ESPECÍFICOS DO WHATSAPP/EVOLUTION
            $table->string('whatsapp_chat_id')->nullable()->after('external_id')
                ->comment('ID do chat no WhatsApp (remoteJid sem @s.whatsapp.net)');
            
            $table->string('whatsapp_remote_jid')->nullable()->after('whatsapp_chat_id')
                ->comment('JID completo do WhatsApp (ex: 5511999999999@s.whatsapp.net)');
            
            $table->string('evolution_instance_name')->nullable()->after('whatsapp_remote_jid')
                ->comment('Nome da instância Evolution responsável');
            
            $table->enum('whatsapp_status', ['active', 'archived', 'blocked', 'deleted'])->nullable()->after('evolution_instance_name')
                ->comment('Status do chat no WhatsApp');
            
            $table->timestamp('last_whatsapp_activity')->nullable()->after('whatsapp_status')
                ->comment('Última atividade registrada no WhatsApp');
            
            $table->string('whatsapp_profile_name')->nullable()->after('last_whatsapp_activity')
                ->comment('Nome do perfil do contato no WhatsApp');
            
            $table->string('whatsapp_profile_picture')->nullable()->after('whatsapp_profile_name')
                ->comment('URL da foto do perfil do WhatsApp');
            
            $table->boolean('is_whatsapp_business')->default(false)->after('whatsapp_profile_picture')
                ->comment('Indica se o contato é WhatsApp Business');
            
            $table->json('whatsapp_labels')->nullable()->after('is_whatsapp_business')
                ->comment('Labels/etiquetas do WhatsApp Business');
            
            // ✅ ÍNDICES PARA PERFORMANCE
            $table->index(['whatsapp_chat_id', 'evolution_instance_name'], 'idx_whatsapp_chat_instance');
            $table->index(['whatsapp_remote_jid'], 'idx_whatsapp_remote_jid');
            $table->index(['whatsapp_status', 'last_whatsapp_activity'], 'idx_whatsapp_status_activity');
            $table->index(['evolution_instance_name', 'status'], 'idx_evolution_instance_status');
        });
    }

    public function down(): void
    {
        Schema::table('conversations', function (Blueprint $table) {
            // ✅ REMOVER ÍNDICES PRIMEIRO
            $table->dropIndex('idx_whatsapp_chat_instance');
            $table->dropIndex('idx_whatsapp_remote_jid');
            $table->dropIndex('idx_whatsapp_status_activity');
            $table->dropIndex('idx_evolution_instance_status');
            
            // ✅ REMOVER COLUNAS
            $table->dropColumn([
                'whatsapp_chat_id',
                'whatsapp_remote_jid',
                'evolution_instance_name',
                'whatsapp_status',
                'last_whatsapp_activity',
                'whatsapp_profile_name',
                'whatsapp_profile_picture',
                'is_whatsapp_business',
                'whatsapp_labels'
            ]);
        });
    }
};