<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('evolution_statistics', function (Blueprint $table) {
            $table->id();
            
            // ✅ IDENTIFICAÇÃO
            $table->string('instance_name')
                ->comment('Nome da instância');
            
            $table->date('date')
                ->comment('Data das estatísticas');
            
            $table->enum('period_type', ['hourly', 'daily', 'weekly', 'monthly'])
                ->default('daily')
                ->comment('Tipo de período');
            
            // ✅ CONTADORES DE MENSAGENS
            $table->integer('messages_sent')->default(0)
                ->comment('Mensagens enviadas');
            
            $table->integer('messages_received')->default(0)
                ->comment('Mensagens recebidas');
            
            $table->integer('messages_failed')->default(0)
                ->comment('Mensagens que falharam');
            
            $table->integer('messages_delivered')->default(0)
                ->comment('Mensagens entregues');
            
            $table->integer('messages_read')->default(0)
                ->comment('Mensagens lidas');
            
            // ✅ CONTADORES DE CONVERSAS
            $table->integer('conversations_started')->default(0)
                ->comment('Conversas iniciadas');
            
            $table->integer('conversations_active')->default(0)
                ->comment('Conversas ativas');
            
            $table->integer('conversations_closed')->default(0)
                ->comment('Conversas fechadas');
            
            // ✅ CONTADORES DE CONTATOS
            $table->integer('new_contacts')->default(0)
                ->comment('Novos contatos');
            
            $table->integer('active_contacts')->default(0)
                ->comment('Contatos ativos');
            
            // ✅ PERFORMANCE
            $table->decimal('avg_response_time', 8, 2)->nullable()
                ->comment('Tempo médio de resposta (segundos)');
            
            $table->decimal('uptime_percentage', 5, 2)->default(0)
                ->comment('Percentual de uptime');
            
            $table->integer('connection_drops')->default(0)
                ->comment('Quedas de conexão');
            
            $table->integer('reconnections')->default(0)
                ->comment('Reconexões');
            
            // ✅ ERROS E PROBLEMAS
            $table->integer('webhook_errors')->default(0)
                ->comment('Erros de webhook');
            
            $table->integer('api_errors')->default(0)
                ->comment('Erros de API');
            
            $table->integer('timeout_errors')->default(0)
                ->comment('Erros de timeout');
            
            // ✅ TIPOS DE MÍDIA
            $table->integer('text_messages')->default(0)
                ->comment('Mensagens de texto');
            
            $table->integer('image_messages')->default(0)
                ->comment('Mensagens de imagem');
            
            $table->integer('audio_messages')->default(0)
                ->comment('Mensagens de áudio');
            
            $table->integer('video_messages')->default(0)
                ->comment('Mensagens de vídeo');
            
            $table->integer('document_messages')->default(0)
                ->comment('Mensagens de documento');
            
            $table->integer('other_messages')->default(0)
                ->comment('Outros tipos de mensagem');
            
            $table->timestamps();
            
            // ✅ ÍNDICES E CONSTRAINTS
            $table->unique(['instance_name', 'date', 'period_type'], 'idx_unique_stats');
            $table->index(['instance_name', 'date'], 'idx_instance_date');
            $table->index(['date', 'period_type'], 'idx_date_period');
            
            // ✅ FOREIGN KEY
            $table->foreign('instance_name')->references('instance_name')->on('evolution_instances')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('evolution_statistics');
    }
};