<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('message_attachments', function (Blueprint $table) {
            // ✅ AUMENTAR TAMANHO DOS CAMPOS DE URL
            $table->text('external_url')->nullable()->change();
            $table->text('whatsapp_media_url')->nullable()->change();
            $table->text('whatsapp_direct_path')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('message_attachments', function (Blueprint $table) {
            $table->string('external_url', 255)->nullable()->change();
            $table->string('whatsapp_media_url', 255)->nullable()->change();
            $table->string('whatsapp_direct_path', 255)->nullable()->change();
        });
    }
};