<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('conversation_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conversation_id')->constrained('conversations')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('assigned_by')->constrained('users')->onDelete('cascade');
            $table->enum('role', ['primary', 'secondary', 'observer'])->default('secondary');
            $table->boolean('is_primary')->default(false);
            $table->timestamp('assigned_at')->useCurrent();
            $table->timestamps();
            
            // ✅ ÍNDICES PARA PERFORMANCE
            $table->unique(['conversation_id', 'user_id'], 'unique_conversation_user');
            $table->index(['conversation_id', 'role']);
            $table->index(['user_id', 'is_primary']);
            $table->index('assigned_at');
        });
    }

    public function down()
    {
        Schema::dropIfExists('conversation_assignments');
    }
};