<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Adiciona 'sticker' no ENUM atual
        DB::statement("
            ALTER TABLE tbl_messages 
            MODIFY COLUMN message_type 
            ENUM(
                'text',
                'image',
                'audio',
                'video',
                'document',
                'location',
                'contact',
                'system',
                'sticker'
            ) 
            NOT NULL
        ");
    }

    public function down(): void
    {
        // Reverte removendo 'sticker'
        DB::statement("
            ALTER TABLE tbl_messages 
            MODIFY COLUMN message_type 
            ENUM(
                'text',
                'image',
                'audio',
                'video',
                'document',
                'location',
                'contact',
                'system'
            ) 
            NOT NULL
        ");
    }
};