// modules/Chat/resources/js/app.js
import "../css/app.css"
import PaginaChat from "@Chat/views/PaginaChat.vue"
import './servicos/chatService.js'

if (window.Innoclapps) {
  Innoclapps.booting(function (app, router) {
    // Registrar componente sidebar globalmente
    const ChatSidebar = () => import('@Chat/componentes/ChatSidebar.vue')
    app.component('ChatSidebar', ChatSidebar)
    
    // Rotas principais
    router.addRoute({
      path: "/chat",
      component: PaginaChat,
      meta: { title: "Chat" }
    })

    router.addRoute({
      path: "/chat/channels", 
      component: PaginaChat,
      meta: { title: "Canais" }
    })

    // Rota de configurações
    router.addRoute("settings", {
      path: "chat",
      component: () => import("@Chat/views/SettingsChat.vue"),
      meta: { title: "Configurações do Chat" }
    })
  })
}