// modules/Chat/resources/js/composables/useChatEmoji.js
import { ref } from 'vue'

export function useChatEmoji(options = {}) {
  const {
    onEmojiSelected = null
  } = options

  // ===== ESTADO =====
  const mostrarEmojiPicker = ref(false)

  // ===== EMOJIS DISPONÍVEIS =====
  const emojisDisponiveis = [
    '😀', '😃', '😄', '😁', '😆', '😅', '😂', '🤣', '😊', '😇',
    '🙂', '🙃', '😉', '😌', '😍', '🥰', '😘', '😗', '😙', '😚',
    '😋', '😛', '😝', '😜', '🤪', '🤨', '🧐', '🤓', '😎', '🤩',
    '🥳', '😏', '😒', '😞', '😔', '😟', '😕', '🙁', '☹️', '😣',
    '😖', '😫', '😩', '🥺', '😢', '😭', '😤', '😠', '😡', '🤬',
    '🤯', '😳', '🥵', '🥶', '😱', '😨', '😰', '😥', '😓', '🤗',
    '👍', '👎', '👌', '✌️', '🤞', '🤟', '🤘', '🤙', '👈', '👉',
    '👆', '🖕', '👇', '☝️', '👋', '🤚', '🖐️', '✋', '🖖', '👏',
    '🙌', '🤲', '🤝', '🙏', '✍️', '💪', '🦾', '🦿', '🦵', '🦶',
    '❤️', '🧡', '💛', '💚', '💙', '💜', '🖤', '🤍', '🤎', '💔',
    '❣️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '☮️'
  ]

  // ===== MÉTODOS =====
  function toggleEmojiPicker() {
    mostrarEmojiPicker.value = !mostrarEmojiPicker.value
  }

  function fecharEmojiPicker() {
    mostrarEmojiPicker.value = false
  }

  function inserirEmoji(emoji) {
    if (onEmojiSelected) {
      onEmojiSelected(emoji)
    }
    fecharEmojiPicker()
  }

  function handleClickOutside(event) {
    const emojiContainer = document.querySelector('.emoji-picker-container')
    const emojiButton = event.target.closest('.botao-acao')
    
    if (mostrarEmojiPicker.value && 
        emojiContainer && 
        !emojiContainer.contains(event.target) && 
        !emojiButton) {
      fecharEmojiPicker()
    }
  }

  // ===== CLEANUP =====
  function cleanup() {
    mostrarEmojiPicker.value = false
  }

  return {
    // Estado
    mostrarEmojiPicker,
    emojisDisponiveis,
    
    // Métodos
    toggleEmojiPicker,
    fecharEmojiPicker,
    inserirEmoji,
    handleClickOutside,
    cleanup
  }
}