// modules/Chat/resources/js/composables/useChatStatusNotifications.js
import { ref } from 'vue'

export function useChatStatusNotifications() {
  // ===== ESTADO =====
  const statusEnvio = ref(null)
  let statusTimeout = null

  // ===== MÉTODOS =====
  function mostrarStatusEnvio(tipo, mensagem, icone, duracao = 3000) {
    statusEnvio.value = { tipo, mensagem, icone }
    
    if (statusTimeout) {
      clearTimeout(statusTimeout)
    }
    
    statusTimeout = setTimeout(() => {
      statusEnvio.value = null
    }, duracao)
  }

  function limparStatus() {
    statusEnvio.value = null
    if (statusTimeout) {
      clearTimeout(statusTimeout)
      statusTimeout = null
    }
  }

  // Métodos de conveniência
  function showSuccess(mensagem, icone = 'CheckCircle') {
    mostrarStatusEnvio('success', mensagem, icone)
  }

  function showError(mensagem, icone = 'XCircle') {
    mostrarStatusEnvio('error', mensagem, icone)
  }

  function showWarning(mensagem, icone = 'ExclamationTriangle') {
    mostrarStatusEnvio('warning', mensagem, icone)
  }

  function showInfo(mensagem, icone = 'InformationCircle') {
    mostrarStatusEnvio('info', mensagem, icone)
  }

  // ===== CLEANUP =====
  function cleanup() {
    limparStatus()
  }

  return {
    // Estado
    statusEnvio,
    
    // Métodos
    mostrarStatusEnvio,
    limparStatus,
    showSuccess,
    showError,
    showWarning,
    showInfo,
    cleanup
  }
}