// modules/Chat/vite.config.js - VERSÃO CORRIGIDA
import concord from '@concordcrm/vite-plugin-module'
import vue from '@vitejs/plugin-vue'
import dotenv from 'dotenv'
import dotenvExpand from 'dotenv-expand'
import laravel from 'laravel-vite-plugin'
import path from 'path'
import { fileURLToPath } from 'url'
import { defineConfig } from 'vite'

const __filename = fileURLToPath(import.meta.url)
const __dirname = path.dirname(__filename)

// ✅ CARREGAR ENV
dotenvExpand.expand(dotenv.config({ path: '../../.env' }))

export default defineConfig({
  build: {
    outDir: '../../public/modules/chat/build',
    emptyOutDir: true,
    // ✅ CONFIGURAÇÕES ESPECÍFICAS PARA MÓDULO
    rollupOptions: {
      output: {
        manualChunks: undefined,
      },
    },
  },
  plugins: [
    laravel({
      publicDirectory: '../../public',
      buildDirectory: 'modules/chat/build',
      hotFile: '../../storage/hot-chat',
      input: [
        __dirname + '/resources/css/app.css',
        __dirname + '/resources/js/app.js',
        __dirname + '/resources/js/global-chat.js',
      ],
      refresh: true,
    }),
    vue({
      template: {
        transformAssetUrls: {
          base: null,
          includeAbsolute: false,
        },
      },
    }),
    concord('chat', __dirname),
  ],
  resolve: {
    alias: [
      {
        find: /@\/([a-zA-Z]+)\/(.*)/,
        replacement: path.resolve(__dirname, '../../modules/$1/resources/js/$2'),
      },
      // ✅ ALIAS ESPECÍFICOS PARA O MÓDULO CHAT
      {
        find: '@Chat',
        replacement: path.resolve(__dirname, 'resources/js'),
      },
      {
        find: '@Core',
        replacement: path.resolve(__dirname, '../Core/resources/js'),
      },
    ],
  },
  // ✅ CONFIGURAÇÕES DE DEV SERVER
  server: {
    hmr: {
      host: 'localhost',
    },
  },
})